define([
    'underscore',
    'backbone',
    'marionette',
    'models/facilities-collection',
    'models/patient-enrolled-facilities',
    'models/patient-identifiers-collection',
    'models/external-links-collection',
    'models/resources-collection',
    'models/user-session',
    'models/community-care-typeOfCares-collection',
    'models/disabled-features-collection',
    'models/api-keys-model',
    'models/configuration-model',
    'json!featureFlagJson',
    'models/community-care-eligibility-model',
    'jquery.mask.config',
    'jquery.mask',
    'jqm.config',
    'jqm',
], function (
    _,
    Backbone,
    Marionette,
    Facilities,
    PatientEnrolledFacilities,
    PatientIdentifers,
    ExternalLinks,
    Resources,
    UserSession,
    CCTypeOfCares,
    DisabledFeatures,
    ApiKeys,
    Configurations,
    FeatureFlagJson,
    CCEligibilityModel
) {
    'use strict';


    var App = Marionette.Application.extend({
        configurations: new Configurations(),
        apiKeys: new ApiKeys(),
        ccTypeOfCares: new CCTypeOfCares(),
        disabledFeatures: new DisabledFeatures(),
        externalLinks: new ExternalLinks(),
        facilities: new Facilities(),
        mainLayoutModel: new Backbone.Model({hasAppMenu: false}),
        patientEnrolledFacilities: new PatientEnrolledFacilities(),
        patientIdentifiers: new PatientIdentifers(),
        resources: new Resources(),
        showingContent: new $.Deferred(),
        ccEligibilityModel: new CCEligibilityModel(),

        onBeforeStart: function() {
            this.userSession = new UserSession({jwtTokenUrl: this.resources.get('token').get('href')});
        },

        onStart: function() {
            // TODO Move things here

        },

        isCcEligFeatureEnabled: function() {
            var jsonModel = new Backbone.Model(FeatureFlagJson);
            var featureFlagExists = jsonModel.has('CC_ELIG_SERVICE_DISABLED');
            var eligServiceDisabled = jsonModel.get('CC_ELIG_SERVICE_DISABLED');
            if (featureFlagExists) {
                return (!eligServiceDisabled);
            }
            return false; // default - eligibility feature is not enabled
        },
    });


    return new App();
});
